﻿using System.Linq;
using Smartling.Connector.Model;
using Smartling.Connector.Security;

namespace Smartling.Connector.Shell
{
  using Translation.Profile;
  using System;

  public partial class TranslationStatus : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      if (SecurityManager.AccessAllowed())
      {
        LoadLanguages();
      }
    }
   
    private void LoadLanguages()
    {
      var languages = new ProfileService().GetAllSupportedLocales();
      foreach (var language in languages.GroupBy(x => x.Name).Select(g => g.First()))
      {
        LanguageOptions.Text += string.Format("<option value=\"{0}\">{1}</option>", language.Name, language.DisplayName);
      }

      var queue = new TranslationQueue();
      foreach (var submitter in queue.GetAllSubmitters())
      {
        Submitters.Text += string.Format("<option value=\"{0}\">{0}</option>", submitter);
      }
    }
  }
}
